"use client"

import { type ColumnDef } from "@tanstack/react-table"
import { TransformedUser } from "../type/transformers"
import { Avatar, AvatarFallback, AvatarImage } from "@/components/ui/avatar"
import { DropdownMenu, DropdownMenuContent, DropdownMenuItem, DropdownMenuTrigger } from "@/components/ui/dropdown-menu"
import { Button } from "@/components/ui/button"
import { Text } from "@/components/typeography/text"
import { WorkflowButtonRevoke } from "./workflow.button-revoke"
import { userGroupDescriptions } from "@/config/constants"

export const columns: ColumnDef<TransformedUser>[] = [
  {
    accessorKey: "icon",
    accessorFn: (v) => v.displayName,
    cell: ({ cell }) => {
      const displayName = cell.getValue<string>()
      return (
        <Avatar>
          <AvatarImage src={""} alt={displayName} />
          <AvatarFallback>{INTERNAL__extractFallbackLetter(displayName)}</AvatarFallback>
        </Avatar>
      )
    }
  },
  {
    accessorKey: "username",
    accessorFn: (v) => v.displayName,
    cell: ({ cell }) => {
      const displayName = cell.getValue<string>()
      return (
        <div className="grid flex-1 text-left text-sm leading-tight">
          <span className="truncate">{displayName}</span>
          {/* <span className="truncate text-xs">{}</span> */}
        </div>
      )
    }
  },
  {
    accessorKey: "Actions",
    accessorFn: (value) => value,
    header: () => {
      return 'Actions'
    },
    cell: ({ cell }) => {
      const _value = cell.getValue<TransformedUser>()
      const matchingGroup = userGroupDescriptions.find((d) => d.value === _value.group)

      return (
        <div className="flex flex-row gap-2 justify-end">
          <div className="inline-flex -space-x-px rounded-lg shadow-sm shadow-black/5 rtl:space-x-reverse">
            <DropdownMenu>
              <DropdownMenuTrigger asChild>
                <Button
                  variant={"outline"}
                  className="data-[state=open]:bg-sidebar-accent data-[state=open]:text-sidebar-accent-foreground grid grid-cols-[1fr,_auto] gap-2 rounded-none shadow-none first:rounded-s-lg last:rounded-e-lg focus-visible:z-10"
                  disabled
                >
                  {matchingGroup?.display}
                </Button>
              </DropdownMenuTrigger>
              <DropdownMenuContent
                className="max-w-96 min-w-[--radix-dropdown-menu-trigger-width]"
                align="end"
              >
                {userGroupDescriptions.map((version) => (
                  <DropdownMenuItem
                    key={version.display}
                    className="flex flex-col gap-1 justify-start items-start"
                  >
                    <Text variant={"p"} affects={"small"} override={"removeMarginsAndLeading"} className="pb-1">
                      {version.display}{" "}
                    </Text>
                    <Text variant={"p"} affects={"subtle"} tint={"muted"} override={"removeMarginsAndLeading"} className="pb-1">
                      {version.description}
                    </Text>
                  </DropdownMenuItem>
                ))}
              </DropdownMenuContent>
            </DropdownMenu>

            <WorkflowButtonRevoke
              data={_value}
              className="rounded-none shadow-none first:rounded-s-lg last:rounded-e-lg focus-visible:z-10"
            />
          </div>
        </div>
      )
    },
  },
]

function INTERNAL__extractFallbackLetter(name: string) {
  if (!name) {
    return "??"
  }

  if (name.length < 2) {
    return "??"
  }

  const split = name.split(' ')
  if (split.length < 2) {
    return name[0] + name[1]
  }

  return split[0][0] + split[1][0]
}

